;coded by UEZ build 2016-04-22 - thanx to Eukalyptus for fixing a path issue :-)
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <Array.au3>
#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>


_GDIPlus_Startup()
Global $iFPS = 0, $iShowFPS = 0, $bExit
Global Const $iW = 1200, $iH = 500, $sTitle = "GDI+ Wavy Chars v1.1"
AutoItSetOption("GUIOnEventMode", 1)

GDIPlus_WavyChars()

_GDIPlus_Shutdown()


Func GDIPlus_WavyChars()
	$bExit = False
	Local Const $hGUI = GUICreate($sTitle, $iW, $iH)
	GUISetState(@SW_SHOW, $hGUI)
;~ 	GUISetCursor(16, 1)

	;create canvas elements
	Local Const $hDC = _WinAPI_GetDC($hGUI)
	Local Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
	Local Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
	Local Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
	Local Const $hCanvas = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
	_GDIPlus_GraphicsSetSmoothingMode($hCanvas, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($hCanvas, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	Local Const $hImage_Clr = _GDIPlus_BitmapCreateFromMemory(_grey_wash_wallpng())

	Local Const $hBrush_Clr = _GDIPlus_TextureCreate($hImage_Clr), _
				$hBrush_FPS = _GDIPlus_BrushCreateSolid(0xF0FFFFFF), _
				$hFormat_FPS = _GDIPlus_StringFormatCreate(), _
				$hFamily_FPS = _GDIPlus_FontFamilyCreate("Arial"), _
				$hFont_FPS = _GDIPlus_FontCreate($hFamily_FPS, 8), _
				$tLayout_FPS = _GDIPlus_RectFCreate(0, 0, 60, 16)

	$iFPS = 0
	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	AdlibRegister("CalcFPS", 1000)

	Local $bFont = _Ravie()
	Local Const $hCollection = _GDIPlus_FontPrivateCreateCollection()
	Local $tFont = DllStructCreate('byte[' & BinaryLen($bFont) & ']')
    DllStructSetData($tFont, 1, $bFont)
    _GDIPlus_FontPrivateAddMemoryFont($hCollection, $tFont)
	$bFont = Null
	Local $hPath = _GDIPlus_PathCreate(), $hPen = _GDIPlus_PenCreate(0xE0404080, 12)
	Local Const $hImage = _GDIPlus_BitmapCreateFromMemory(_Texture0205jpg())
	Local Const $hBrush = _GDIPlus_TextureCreate($hImage)
	Local Const $hFamily = _GDIPlus_FontFamilyCreate("Ravie", $hCollection), $hFormat = _GDIPlus_StringFormatCreate()
    Local $tLayout = _GDIPlus_RectFCreate(0, 0, $iW, $iH)
	_GDIPlus_StringFormatSetAlign($hFormat, 1)
	_GDIPlus_StringFormatSetLineAlign($hFormat, 1)
	_GDIPlus_PenSetLineJoin($hPen, 2)


	Local $sString = "AutoIt"
	_GDIPlus_PathAddString($hPath, $sString, $tLayout, $hFamily, 1, 210, $hFormat)
	_GDIPlus_PathFlatten($hPath, 0.1)

	Local $aData = _GDIPlus_PathGetData($hPath)
	Local $aMod[$aData[0][0] + 1][2]
	For $i = 1 To $aData[0][0]
		$aMod[$i][0] = $i
		$aMod[$i][1] = -$i / 2
	Next

	Do

		DllCall($__g_hGDIPDll, "int", "GdipFillRectangle", "handle", $hCanvas, "handle", $hBrush_Clr, "float", 0, "float", 0, "float", $iW, "float", $iH)

		For $i = 1 To $aData[0][0]
			$aData[$i][0] += Cos($aMod[$i][0] / 2)
			$aData[$i][1] += Sin($aMod[$i][1] / 3)
			$aMod[$i][0] += 0.95
			$aMod[$i][1] -= 0.5
		Next
		_GDIPlus_PathDispose($hPath)
		$hPath = _GDIPlus_PathCreate2($aData)

		_GDIPlus_GraphicsFillPath($hCanvas, $hPath, $hBrush)
		_GDIPlus_GraphicsDrawPath($hCanvas, $hPath, $hPen)

		_GDIPlus_GraphicsDrawStringEx($hCanvas, "FPS: " & $iShowFPS, $hFont_FPS, $tLayout_FPS, $hFormat_FPS, $hBrush_FPS) ;draw fps

		_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY) ;blit drawn bitmap to GUI

		$iFPS += 1
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	;release resources
	_GDIPlus_FontPrivateCollectionDispose($hCollection)
	_GDIPlus_ImageDispose($hImage_Clr)
	_GDIPlus_ImageDispose($hImage)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_PenDispose($hPen)
	_GDIPlus_FontFamilyDispose($hFamily)
	_GDIPlus_StringFormatDispose($hFormat)
	_GDIPlus_PathDispose($hPath)
	_GDIPlus_FontDispose($hFont_FPS)
	_GDIPlus_FontFamilyDispose($hFamily_FPS)
	_GDIPlus_StringFormatDispose($hFormat_FPS)
	_GDIPlus_BrushDispose($hBrush_Clr)
	_GDIPlus_BrushDispose($hBrush_FPS)
	_GDIPlus_GraphicsDispose($hCanvas)
	_WinAPI_SelectObject($hDC_backbuffer, $DC_obj)
	_WinAPI_DeleteDC($hDC_backbuffer)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	GUIDelete($hGUI)
EndFunc   ;==>GDIPlus_WavyChars

Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS() ;display FPS
	$iShowFPS = $iFPS
	$iFPS = 0
EndFunc   ;==>CalcFPS

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2015-09-19

Func _grey_wash_wallpng($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $grey_wash_wallpng
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= 'NdcHoDcdUE92EFczryXbLnkOMmZEz934AaAQVxmNmtQnx2yX42suIJVO0jrbfxtQwNMjGrnLaIlmam2DUUsDjLFVSkvLTY2M1I6yALg5mUmZqQgsE3cTp/nKNUEKptfzbrbAwlq1gKJJGEcb7vWfHle7JrLtQji9e7IORNgKvE48JUcWtHecGkJksQ4lSSEOe553vJwvxoE3px+Ut7eYwuxhIfTOMcTk3948I0Kq15HRKmQthQIOP5Id+4jp9GDsKUqO1wcMepfcYsMq1HbGMLFx4tvHaM+cTDns06p57GY2CDof9+9uF3YTY1Kt+pSwJjrk5QTU55Bm09rwHqDQofBMaeVBoqzBxqOW8ToEbBdimR3TFnvSYYA6xFuVGEMP2v/atb9/f53pghg/CFHNB0s2z2pnJl5eKocmVDzfBauG3ddBQ18+6lEOLVhl+V1TRYaoStf/gb4Y4rQBOo8Rmm2cxFMtyW+SANhA5oYIofLJIj27W/S9v96fp/11IIAgjLCQ054aPjme/f2hTbv0Pf2hc/D7XJsnoPVZHLpS6xBOQno81yLXwJiVWXmSVBr2+VddkeIwU/oVwFwuNTutspqlNtNAfXhstzmDkxywI0zjRqlk1oigEHyCoA5/F3AWSvFU656MDF+zq9dC+7qbS98neVwumcVjNM7lEBvfArcpJrRj7kXS4VDPk/XNJr1re26ywW9TC+VA4DYk+R+3Z8ZfJ69NUP1JOmsWBpQ1XQlMXwQlHCJm8EsbqJngM+hA5oJW+qNhbAOXpfkdYBYur3O2yNEMuVr3sdY7VeQW41ftMDVCtQWRVE8fMwKPmtZpDBGr6d9/jiPdR8nstM8m0Chqic+Zw4tgXOu7apAAfkRtcUWgfxQNpiRIMnu56mGqPKiPfrx1gumDynsCD1e0xApan5lYenm4V11CK459ia4ZJqEG/rMqlVUXPqRLAHr8gKat2mhCxDFwMJD1yFyYAh25FpHBE37kF94aqSWN588o/SmaqTiuJ/767KVdVJDmNc2YPs7Q0kneFJQrNd49R/4IyjTTspiVsoKzKlPPXSSDZIrZ6bViIGJrUOcYm0RmxPgZNi2Gaad8B6gfYWJxDSPn/D4z3nbNajyu0eRa36rqDfZ0MKmlUctXHAir/uqX7W1ewuzaQ1TeNubVO+JW6xsVDO2XsNzOGwKFIpoPF1lC46fEAp8KUauHmiuJ3aqd2Gfu1ii1DscFbmvtu8mjfex+XW4qEdmivqv5WTReeMLcqEVPXI8jKUrWjmuZdmsEUvgvK8vpr/hFYgmv74LGm2Ylz2K7Xz97t/1ztbIcrlBYsjHqjGTdATZdPWcxFAt+h5bnakNP0oKfxes0B8bdT6VK4Ibs5UDTXUzkeBeNMA8RfanYV0zFipgT8hACYVjX2aIasNphgXAoDgDAnnD5Qqjw+fupSvo8uBEjlciEGV4It0/tQl7Hr3o0LIVTJHZSjAxTxDWYcvh4ujU/1EpyJ8NzQnCsaDEpKrF60S7K+7OIkJUlK/f11ocIqz/XiKPVnK4JoF6VzDsLIAGCKeH2Vs/xYLKBVLj68yjh6FCr1VUmcM45cC1p3ZUlXcdN+O4pvfXRZCgNZPVTu1bOdfCJA8xGQTJsjBxQwbOqvEKX8l18mFa8eaeMelcNjRPTfhZfq1qTHpXsAH7hrmyA8XDoHFgiDlvJuh2WuT+WPSKs+kA/Htfu4Av9+jKQWE/8jYnKRDrOfyCuJMNYtonDAOC4LoqLnIK1Vs+bsgmOK9tbdXZXWZqfKEbvd2NA1Zj9r0Nw+G2tlN1w521TE25X1azGmdWfQ0Fapw2T4ai83LssGcEy9OOzMJx2f2qxNrMMD1LuAi7KCHILuhq9LeM3HVCQ4G6BNcUqro2R5d0oAq2hcLcCuamfgQBXM95Q8XqxtYDcmPjtbrEtbfPmTOno25L3Zl4TcDLd0sgpNIqZjNpcn7m37c+ejUau7d/m2CNDBiKcRsFQiJtjTFw43zpH'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= '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'
	$grey_wash_wallpng &= 'q17sRU/MHBTZhOKqRJHd03lEWgfcfQphL8lG26/x8i8A6jBS3dGKUvy8k+n1upmAAQvIh4pkVa8Boy2tKkHLB3FHe7rbgOhH+ki653GcxDU5CUYoHMvkNxVMDEdV1k1ikUJqAe8elY9FQgFA5BgvdD7b4HKq5h+UKFrBuNuUEZsj18W+XMJq6AsGa/5za6J2rVQyBVWtN2fFVWBVV6ZEfS4hn+IFNZps2y6f+MoTJWcBYU2aDe+vKTdgEDTXLVT4Dc0iPd5xJkJW6yJlB/2E59ih0s2nT0i1SbwMD95c1+XTBDUg06AtnPE7/25x39oJUP2EY8P7Em3U1vhegyVGnn4xSVCboDs4hkyaovB3lX6zuW22SgoOg53K2/4Zo7mWqHfDK+w/8H8bZh3HqnbEhY9JFQ0jfdgsamsozDiOUOEyecYKdB/DODpIWqIplPRBEyOLHKAp9k/v12NWxvaSSPhHNFLqlgkkbflLYFBVdEYZoTbDcUP+WabE+kOuW84C1Ht+xKPFbqntIpcWVV0tZxYVRWRdVY1rEis7klfUEhvJrHHkGLYa6usGd4E0ktCj2UHAk3lTLmuG86laV37MtirT7Hr0gtKIX98LIgT+R27LXOyNNB0BBev3ooFvUbAmUAY8qrm4Cu/fx3381vQ5/j0/v59PIgnMEg/KdEOfoM/UUDsirV+xlv/9xUZkSU3klo8iGvAn5dtYF99mZGMIg/WNXur+tUik0vZ21EIIktmrhTUB4lOFCuY00afygmWlt5VMekkysYost62igGU5br/FLdyH03evGMigvhz+bSnZHgua4aCGMcJ4lF4Sflmbe45wOd9ZatQiRI2YyTsHGNdjS1xI0plp3osIAOYzsZ1Czvede2htdzEhe0CC8lhOpkpI7pQWYShYhR2W7BdEm9ClqpLihF7O46dGGv9ObVrHnU1bUInb6iK3OukcEhW9hTRen6S4jQdtaFet3/9zZcYq9f5TYgNC5IiAY52srhtnya9MR4RRUq4t9/DnvYCcTIJoBVST9yktDoVdtC4iUumFy7HwcRbXRVWQOPFLy50I78Ap6ErVN55E1/bP/zKfhaSCgS5uo4/gKCmrq0O9WZdZUvaj6BUfixh7tjkG9ODYo/WtqscF67n6bD0xInzP8BPjV+rvPyS12pxv5ShVCz3WedyfNBF5sqizIkvRnfSy5EpQ8dEOuM+J9vQppPD/D2wIAkydFBhKAAAAAElFTkSuQmCC'
	Local $bString = _WinAPI_Base64Decode($grey_wash_wallpng)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\grey_wash_wall.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_grey_wash_wallpng

Func _Texture0205jpg($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Texture0205jpg
	$Texture0205jpg &= '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'
	$Texture0205jpg &= 'hajCpj1For0uCD6Cjzdq1vSfcpkBJ/MEwIjPq5StFC+V9w8SaTy48PRedbohk1b7g8dYIVcIKETPBcHmh1RBDvPgZhvvHIWy/rMCeQ6wj4im+OJqk7mEhKnt0Wgok6cU+uJpI9S+v3kYoQX8dwLVdP5Mokg+jFUQ833mrXiP3qUhlZg2r7V95E8LwHv+5OFYNMOxgpRDCxgTxmCiEK4Up4c8t1n1ddAUMLGHGnQmR+C4HSKGGfXXBI8MhE+CHvfYBQK6QDwV5zkKIDHakSIHxoQAQs+M6xcHXXD4aJfDoQEi/TlbQF+3cEIArvELbeNRwtrzUjRg+8nooIdfc1gQ8YgwJJUdQQCVzrlCtpATzA5wqg+3zCD4uBea9wneL3IJEgl+6vrVnj9wIh/enFRYUAL3KI5hxzqTeKOOMP6ylA8p85RZgK4xcUIB3mYWacNoRxS8CYn5T1+6FACvrEEMJXO3moxPuMjhhZzILO0FLMumoUnJIgCAOriAhTPrnHTgL3ICEQfWSTZQsrnowwHJXAGtfDrhQKE/RdzX80P/ALliJOQ+DDv8wGAg9eBZMhQoong1hCA1YJB+xdLIA9eM1EVW/BigChwuGfjUvhnKAri81UFCKGSJ0FHLILLHwZPFjS+8/jW7oK3AUEP8xd0LwA6uCyAc+3KQFUT8MmDQlCzIhZ9L6wgNCMMX/Mi0EsMAkAFP73w8FWaUlAGC/fLS8MDJRF/XMzdFVfxrm1tA91IGNUPdFGgJEDEcQ1TR6ynB9cCy49+Bv//Z'
	Local $bString = _WinAPI_Base64Decode($Texture0205jpg)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\Texture0205.jpg", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Texture0205jpg

Func _Ravie($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Ravie
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= 'ANtSANwA5//CEADdAOhQAN4A6RD/wQDfUgDgAOxFUADhUgDiAO1QAOMAAO7/wADkAO8BUADlAPH/vwDmEVIA5wDyUADoAPMRUADpAPVQAOoA9kD/vgDrAPdQAOwBUgDtAPn/vQDuRAD6UADvAPtQAPABUgDxAPz/vADyBAD+UADzAP//uhAA9AEAUAD1AQERUAD2AQJQAPcBBEVQAPhSAPkBBVAA+gQBB1AA+wEI/7lQAPwBCVAA/VIA/gQBC1AA/wEM/7kAQKVQTw4fIE8AME9ATwNPUgxAH1RSDh9RMABTATAAAFIQUmBSA6BkSxAfYzAAYTAAKk4wAE0wAEwwAGBcCAofXzAAXlwRH4JdMABDQQgfQjAAACMORSIMRSEKAEUgCEUfBkUeAARFHQJFHABFAC8JPwk/CwMaAAgYCBYIFAgSAAgQCA4IDAgKAAgICAYIBAgCCAgACLFmAAkBAglgZigo0GcSEQgCAEA3Dz+4AQCxABYBS7gH/1JLALAIUFtYsQEBAI5ZsBJLAEtUBEK5QAP/hY1CAQAdS7AdU1iwYCAdWUuwgIAAAB0AsRYAQlkrsQIAAEKyFxEBiCAAsCJRiiN4sEAAUnixCiCIuBAAAFV4sQIBQrAAAxwhIQFFaVMAI0NcWkIBS1BIWLEIgANDXHMAFgAQcD64QAAgsAAkRWOwAkUgsAAAVFghuAYAWQBisBJDWBu4AoAAYLgEAGIjhQAAsAsrI1mwCyMAQrAKI0IAPz8AGCsQPAEvBgyEsAYgAQcjQisKAAZz6wBIAXMrAEA6AFFQT05NTEtKAElIR0ZFRENCAEFAPz49PDs6ADk4NzY1Ly4tACwoJiUkIyIfABgUERAPDQsKAAkIBwYFBAMCAAEALEUjRmAgALAmYLAEJiNIpEgt8QAjYQABYQgBOGCwICABYAA5ArAgV3EDYACbAkCQAmacAkAFkwJAlgIBECA8AAA8LSwgRSMgsADNRCMguAFaUQJYsACNRCNZILBK7bIATbIABCbCAA0JwAAhIRADIEUYaABEILABYCBFsIBGdmiKRWBE8AQAsQsKQyNDZQpALSwAsQoLoAALAZAAsCgjcLEBKIQ+AYIAAihFOkAeBAgNYQewAyVFYQBksFBRWEVEG0ghIVkyAQBDsgSwkAZDsAeyBCBpMQsAAIsgsSzAiowBkCBiYCsMZCNkQGFcWLADYUADigADRYqKh7ARKwCwKSNEsCl65AIYIA9lsCwjREVIsCsjwARLUgYGAQCwBSUQIyCK9aIAwAsj7ewbAWEUAeAGJRD1AKEAIQ5mEjvwAbUAALAJEArwDSEhFbEIi0AnYsAAsIBRAljzACAAYhuyAIBALytZsAJgkQHSwJUBFVWRAYCVAeYDhGAjkBVFI0VgJAAAdmgYsIBiIC02LNAXIgAlIADwASCwQAMmYGJjaHEAYTBliiNEEA5xE1RYSLBARIAAQGG0DkVIsTAv8AJhYEAMaQFhEFFYsC8jcLC4FCNCAwIAAUAEJdA0BlgiA2QDsBRDsADEYGNUA7AvRVAAICIcRYqBGQEKsQQjUVgCuQCX4LE0IBuzijNAlllxCLAWQ0AZACZFilhkZrAfCGAbZPApZiBYGxAhsEBZ4BNZI1gEZVlRGiMQsCng/+AGAAAQB1IDsA3cAsUCkQ8AByUIIFgCGwMmWdEaAAEgRkAAI0I6PIABEOAa4gARHUI84CBYARsAZQJQBhQCh5EAegTAAAMlQ0ihAcIDoQNDSBshwC0CAAsvCSYJGzQJBSWwCP24BBAAATYJcwavCaQJ0wLBAQkpIEVlRAgKSgXfwAACCtQEfwpxCgKxEIQHlRADCOEcSKUBAyWQO10wAQJgBCIBURwYQFFQgCBYI2UjWSMwJDhAUFixDbEW8h1LU2AjS1FaWNIeVCJUO9oA8wE4tgGUABUAIIqgCCNLU4oxAiOkAUAAIIpJsADAJ0BRYDY4EjRTAUZwSooAikYjIEaKYIoAYbj/gGIj'
	$Ravie &= 'IBAAI4qxQECKcEUBoEoAUFiwxLsAAWG4/7qLG7AARoxZsBBgaAEAOi0sIIojSWQAiiNTWDwbIVlALQAAAAZqAAxKBP+XACgABGb/tUgAAP8ARP9+ATz9GP0AyAEOAQACvwAAAAXzAAABwv8G8QUmSgAyAGQAlgEAb/oBLAFeAZAAAcIB9AImAlgAAooCvALuAyCEA1IrKwQAAIABKgQDM4QBVv/4A8sAAHEFEABKBggAAC0GVAAdBw4AAAICJwBxA0gAAGoDSP/8BJ4AACsFLQAtA1AAAJYEIwBmA3UAAJYFHwAUBf4AADMEAgAQBloAABIGngASB5gA//gGkf/2BmJAAEoFlgA8gAEQMAZe//KBF4AdiwOAQgBKA+EAQoADAAoF6QAGBncAADEHWP++BoH/APAF5QArBrwAAB0G2//0Bi0AABkGTgApBzX/gOUEN//lBieALQC6/+oGcf/lCgA5/+MGmv/yBgqHgBe4gNGJAC8IAm2ACX3//AcE/wDJBtkAJQee/wDfClYAcQdx/wDwB28AKwdtAGABAysAI4FZgAMQAAPwAE0GTP/yAAQzAOUGsAAhAAZQ/9kFzQAfQAYpAB8FycAJ5wHAHwQAAgYt/9NAA/z/7AVzwDTJBP/PwELQCZP/2UAGIf/lBaLADSdAAAQGTAAnwA0IEAX0//7ALAIGUgAAPQYCAAQJF0QARsA1xQbRwAeWAP/7BFIADAKcBACswAEABEwAG//BPcEAwj3BPMU0wC/CJNAA38EowifIAMEnyADPxSbNAAPCJcgABScALwL2AABtBaAAKQYxAABWBagASAQvQcB1tAAxCdPAP4cEADPBAAdW//oECDMBT8BKMQOHABhmCuPALMF99gAkAANGAEQCugBMBcAAYMBe6QMQAG0AA2QAfALbAFUQAyQAJ8EAAef/AOAEWQAVA6kAABUEIAA7CUYAAjfCJOkANwNWACAzA64Ad8Bi+gaASgAEBAoAqsCkCi3AOSfAABAJ0QBglgGaAADFSsFHCiCcACkJH8A+CACAZgeWAGYFjcMADALywwDAJEYDOgAGHsFdwX4E/AACBCDFAI4DVMAjVAAAGgdWABcHRgDgFwVKAFbhUmEG4Qf8CbjgBWEMYDHlAGEA4U//aQBiNGAA4WjmNWQAYTDgJKqLYAB3YAB1YACFYCcKgWAAL2AAAgReAOp4YAL+YACoYVnhSeFWH2FHYVThRGFE4GAXBfrHYC/gF+JH9gAMYU1hcAFgADsCmwALBCEAAAwETQAMCTcAAAsJdwALCucBYATfABcGcQAOFeB2IGATleAskwTvAP/7CRIAFwpKDWAAN+ADYDoD5QAhAARF//kEJgAwFAOh4CKh4Akk//cP4QJpC2EH8QQHQgAThUCIH6CeFAkMBQA3AAQEBgcHCAIEIAQFBgQFYAEFB4AHCQcHBgYHQQOuBEADQABhAAXAAgzBAQIJ4AEJDAgICAQaBuADBWADAgAEBghYBAsHYAkCAAoABQX4AwUFQAcCCAIA4wShCgYGAQChAQYDBgcGSAUGCwEMBQTgCwQAAwMIAwYDBAQgAgUECQqhEAcHEgVgAAsC4AcMCgYQCQYGA6ADCAgGQ6APoAAEAwYLggsFtwAAQAVhDQRhAQMAByIYDgOgEMAHQAcFBQoLBAwIoAIGBgoMC1YHIAUAHwTAAgYiAQjkCg5iIgUGYBzADIAMMWIiCAgKgiBBAwQHNAgJ4AkJIATgBQgNAYEPCwgJCQoNCWQJCWAiBQimHqARBBegDWEPgwQIYSIJCQffgQdoIiEVIwFBAgYgDAAZ1UAsCYASDmIiCaAzYSIcBQlhJAAMYSIMAglgCQgNCwbgNaEqCa4JwSWgC2AmDGARCcAHnSEwBYATQgEEAAgEgDgeCGAiwALAKCASDAwOwgmhAgYLDQ0CKQAAw2MiAAAJCw8GYCJgKSgICQqhAgcAAwcITgYgHuAHYhQFBEADCYPADMAABggLCQ6BDwIM'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= 'IC9HNDQcQHdARgAvLR8fRUQyIAAcNFtFQEVAQAIoAAA9PSY9QEAIQCUnAwApJyc8AB89OEY+GD84AEZAQToxMRgnIChWWWZAQAU1LgBVYGA9JSgnIigiJyWABS5CAkRTAHEqACEhIyc1AD9CSRYiIjA2ACIrJDU+KkJFAE9EQjo6QiQiACIoIj1DTEM9AEZHQEFLLEBQAENqRERGRFdDAElHT2tNTU0hADUhKUEsRUI8AEA8PT5AKTlGACJjQDpAQUA+AEFCPl5DR0QtABstLUxMPUdEaERHRQIAPAEAQc1ACjoBAEIAADUfOkAAOys7ZkRETCwALCVxPjEiHBwASR4kHiEhFC0AJi1gOj0jJkEAQSohPDxmEUwATERuXzRPOjoAHx8iIUdNNDIAIyNMSzckHzqAZUxHTEdHLAAAAEREKkRHR0cpA2EBAAAtLCxDIkMAPk1EG0Y+TUcASEA2NhsrLWAAYnFHQyJEOjMAXmtqRCgsKyYoJisowAIzIgFLXAB9LgAlJSYsOgBFSVEZJiY1PAAmMCg7RS5JTABXTElAQEkoJgAlLSVESlRLRABNT0dJUzBHWQBKdkxLTUthSwBRT1h3VlVVJAA7JC1IME1JQwBHQ0RFRy4/TgAmbkZBR0hHRABJSUVpS05MMgAeMjFUVERPTGxLTyAoAABDAQChiEYKQQEASQAAOyJBRwBBMEJxS0tUMAAwKX1FOCYfHwBRJCchJCQWMgAqLmtBRCYqSABILiVDQ3ESVABUS3ppOldAQAAiIiYlTlU5NgAmJlRUPSgiQEBwVE9UT0/hckuASy5LT09PLsOXAjDAmEomS0RVTAAeTUVVTlBHPAA8Hi8xam19TwGgAkE5aHZ1Sy1SMYCcMC3AAjkiAVMAZIgyACgoKi8AP0tPWBspKToAQSk0K0BLMk8AU19SUEZGUCsAKSkwKUpRXFEASlRWTU9aNU0AYVGAU1JUUmkAUVhWX4FdXV0AKEAoMU80VE8ASU1ISktNMkQAVSl4TUZNT00ASk9PS3JRVVIENiFAXlxKVlNSZFZUAgBJSAAAYKAyEk0gb0ZGoBdPQCUARk1HNEd7UlIAXDQ0LIhLPSkAIiJYJSskJycAGDYuNHRGSioALk9PMihJSXsAFFxcUoVyP18ARUUlJSkoVV0APjwqKlxbQisAJUV5XFZcVlYBoXFSUjJSVlZWBDI0AwA3NDRRKQBRSl1SIVRLXQBVV01BQSE0NgBzdohWUSlSRgA+cYGAUjE1NFAtLTQxwAI+IgFbAAACAIAAAAOAAAZmAAMABwAaAEAKBQMJBAAIAAcBBAAAL80vIM0BEN7NQAAxMAAzESERJSERIQCAAwD9gAIA/gAABmb5moAFZgAAAv/4/5gDJQAGYgAgADEANgBAGQYABEwUCgAOIVAqMhIQXAAYGB8GCi5gJwALHwAAPz/93gAZxhI5GC/9xgABENbt1BnFGADE/cbGMTABBgADAhEUFwYHBoAHJgMmNTQ34AAhoAA0MzIWINw2N4gyAxRAAwYjIqECADYzMhcWAyVGACoqETZPVjZuAEAlD4g7DAQKAAIcB4D/9n0FABx6Z3UtJWB5AIp0c3xNRwZcAKH++/7//veLAIMPGh0b3AFFALt9TysVDR5WABsZBgJFQ0D5APg5OzEVCGBBIEsyKSomICJxBAAGA1oGZAATAAAoACtAFBoeHgAiFAQICABJDAAUSSIpBhwQJRFAGcTdxEAY/d7t4DkvzRESgABADDEKQBQjIicmJ2YKBQ9yC5ELUwGzC1o/QgoADAoVCEY7HycASVAyLv5UORgAFxkGFQoKAg0ARTljUUUmHgUAjVRsb0ULEzMAdWNNVkJTQT0Ib1ZjIU8TCkZ3QGJQXIFPQJAKSgD/tgTHBHUARgAAWACKQEEyMAASEFAiNjQODABHQ0EAQAJFPAA6CAZDIigaHAAmLCogGBYiWQBDQSQiTF0yOgg4LC4AJSgyCgwAFBJFIB4AVF0A'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '1Gg8EN0ACMSCA4MJMRQwJYK1J4C1JxYW7hcAwAEHALE2AMkBvIQHAUEEMzIWFxQXFiYXAWbBBzY3AAcVBifIBwAHQAAzNIETNTSfwQPBE0AAQAvFBwcGAhsHgBtDA0UHNzYXFgQA8AIrMEExJxAAI0SsBAgbe1UATFvdaBEcIZgANyoJJwQXHkcALikXIUE4UgkAEyO6CCYuBwEAAQcxIQi6IxMACVI4QSEXKS4ARx4XBCcJKjcAmCEMIWjdW0wAVXsbBAQErEQAIxAnMUEwKwIAAhohRGMiDCQAFtMHEg8wEQ0AMBEUB9MWJAwAImNEIRqsUkgAT14mESAHsk8ACS0vSjIscmMALwcVJsoGBRQAWwYoUEdXUkEAWkI1EQkkA6IAhhUECwsDJnYAoQMjChE1QloAQVNXR08oBlsAFAUGyyUODy8AYnMtMkkwLAoAJSqyByARJ14AT0hTYUVXAQMAZCINDwehOzQALRALJjg/ogcADw0jZAICWEUCAMCIlgJOAt8DAKAADQARtgBPAAgOBGAKAC/t6AEQ3kDNAYJlAVVAvQAWAt98Z3NmQwBKARB1XmYC0QA9JiAwNl6OOAI9QRFm/xACiwAA+AAbABtADAcAC0YAThQcEQUADV8YAC/9zMRAARDW/f3EQH0Uc8J1QW01NAHYgNuFcAIAi04mOBoRDSAAQxc5HQxQb1EAS3GETEgtRa0AGBMNAxU5IS0ACARoTkMpJjoQNwAAAuENBScAAP4AHAA4ADFAABgkKEYdTjEIAgzgDhUxOQYiKgASDi4qXxk1AFUAgMTghNxBENxgEBAX5BADTBIRBZgUBScoAYBQGxAMIUQWOgIcoBRQTHCETEkE/WRxFzNEWVUYBBIMgBciLQkEaBRPQoEXYBEaBwAnAP/VCX8GNwARAAAjAD8AUQBiAABzAIQAd0A+AH5FSkAwLipMgDQ+PDhKJDQgAAAcdEVAXEUKUgBFAIZjRRJtRQAchRBQXVZ6YACCXQZGLlswNAAYXXFnXSI6WwA+JCICAD/U1gDtEP3e7S/W7cAvPP083sQgdACiZNztggDe7eClwHj90NQZxRikANzkPgdwxUAfIC8CBQYB4XAgcxOAbQFrABOhqSY3MDw3FvAHIAMiqiIGMzICNh8CCX8MFUVeAKmOcnhcaKZDIDgBAPmNAQKojwkAAmmlAQICh7j+AON8a3E0N1JKAJJ+fwLkjxBIAAoKPqcBdQwVJERfAwWmQgEF4hkAOI0qF05PUUQAOUpv1/mNGTcAjSoYTk5RRDgJwAEDL8oBAaIzSgB+UHBcYYdpXwBrFQgCgTNKfQhRb1vEAR/o/kIAw7zEGx8kJwQAA2wXDAkJA+AAAU8nDTc5CAsQR2H7zGoH/tsZABIpBA4zNismIBYSawORpgEVEwhr/NlpAwD///8Avv+sB4sIVAIINgAkQGoXANgBAEwCYAAQQAsCACU5TwIAOzshICVQKzQrIAX0/6DPBsEIKSAFKCQFCD8CNSEFASFwT8ABAHl/MTEkBWMKgi1mCo0A8AJEYwpCQWAKQzcjI2kKBwJyZgqOAOMB/QAAFEANAgEdck+AAgEAe3Y6U2AFKDQrNCYQMaYFQwEocQJIIxBxIBB6cAZTYQXhCuX/uAQ1JSIQLCMQ/5EjEAEiQj8gBUI2Hx8qBTyRJgXY/+40BSI4kAKQOjoRK5kCB2+WAiCO/8MB+rMKIjr5sQpDPlIFswpzBbEK0wKoQwAMtQo5EQg4FQhAACv/WgZckgIyRdQSvpMCAg4q0BIsKCAUHJoCF5YC2AEoUgIjkwIikAIkJAwODpECkEqAAAADIIAGZgADUD4aQAAKBQMJBAAIBwABBAAAL80vzQVwVs0gADEwMxEhABElIREhgAMACP2AApBNBmb5mliABWZfCbAWllUJIxlRCSIUsgaQAiX/pJQG1ZICOPMLARSUDoRIVJAOTk46Q5oCgmeWAtgBwQJzkwIaTJICPZsCNwVDAYkl'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= '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'
	$Ravie &= 'HGyQHXQwAD4RAAQwIPsEBBABAZoAmLsU6qvd+d4ASt5fbK+ggg8gPzCCAsAwACkCABQTibTRiuinAMS9NcebjYjKgB/KU1aRMA22CgQBBCAJgZ4xHzAAHQYDVQQKExYAVmVyaVNpZ24AIFRydXN0IE4AZXR3b3JrMRdEMBUBAgsTDgUCLAAgSW5jLjEsMAoqgwEjlwNpbWUgAFN0YW1waW5nACBTZXJ2aWNlACBSb290MTQwAjLTAitOTyBMSQBBQklMSVRZIABBQ0NFUFRFRFm7ACwgKGMpOTcgAFZlcmlTaWduACwgSW5jLjAeABcNOTcwNTEyKDA3MAAAWgA4OTEIMjMxBDgwgZ4xAB8wHQYDVQQKBBMWBXYgVHJ1cwB0IE5ldHdvciBrMRcwFQFACxNCDgu4MSwwKgMwIwEHcmltZSBTdGEAbXBpbmcgU2UAcnZpY2UgUm9Ab3QxNDAyAy0rAE5PIExJQUJJAExJVFkgQUNDIEVQVEVEFMCBnwAwDQYJKoZIhgD3DQEBAQUAAwCBjQAwgYkCgQCBANMuIPBofAAsLS6BHLEGsgCnC7cRDVfaUwDYdePJMyqy1AD2CVs08+mQ/gAJDNDbG1q5zQDn9oixncCHJQDrfVgQc2p4ywBxFf3GWPYpqwBYXpYE/S1iEQBYgRzKcZTVIgBYL9XMFAWENgC6lKq0TUrp7gA7Iq1WmX4hnABshsBKR5dqtACmNtX8CS3TtIA5mwIDAQABCU8CBAFPgQA6EZyFAAU+0umA+3vVAKn0rHn8BfyVAD1xI6krKN+MABNlif4shwGPAFqaYsoRp4D0ALe+FLfRVplrAAhiRcaipdo1AH8FIt5yLQSGAAWnfAkWkxRDAPD3Fk3WB46bABBsWP4KNZfKAImf3wRwnCp9AGGOwegLcZqoAMdmYkI9lZQiADKYIomK+mQIACT10vowggLNAcAANgIVAL0RmgDaQ+0h+0ZYhACJykaIkCXuFD5gTCz/gP+A24AesawxaCcwJQMWHpshRToLF1Y6sijFRwrORxEwDwEBBgcTCEludGWAcm5ldDCBnY60CotAYYeBtKth7bQArY2QR5DctBEAXmncCn9ikAYAMc3O/4iRRtcASTqU6dQGP50AraJ4Wuz5/GMARU+4C24w76IANqstCd/xbycAqw1RYAU1T38AzlRP0LcsQtgAC9CNuF7/toAA0OOWtH8iSUIAEGzTmLABVqMAw88unzr0f6gAWKbXImXljKsAeJy82UdCaFuALX39tQIBAxBaAG1g+5lfpGmzANN7cCtiIx5EACBRryMVx3QCAPlJ8icaXKyGAHE1CCv2j97gALWW6IunS+NzAMhICZ2w2ovaABWSygPlCSVWAAbnTqRHpdFXAEbUOFb1Ic3DACY7LSUyzpviAL9AR+rYbUd2AOXAMKMPgM5/ANg7fqD5lSoxACsV+sgU7d2wAOlVQXBGLSx+EDCCCaZgAA+gAwACAQICEHlmlgBug7DQtgESbqCdwLRlcSkWAgBaRmGwLjc0MzAxAz4qASZCQ29tbWVyYwBpYWwgU29mdAB3YXJlIFB1YgBsaXNoZXJzIARDQUJSODA0MTYHIVBEUsEBMjM1OTXAOVowggFdnxCfECGaEDFGMESDBj13UHd3LnYAB3MABy4AY29tL3JlcG8Ac2l0b3J5L0MEUFNhDG9ycC4gAGJ5IFJlZi4sIeFaLkxURGFZNjEIPjA84wg1RGlnBGl0AA5JRCBDbABhc3MgMyAtIMBNaWNyb3NAEOcQAFZhbGlkYXRpAG9uIHYyMQswAgnhBwYTAlVTMQgTMBGBAQgTClcIYXNoQG90b24xCBAwDkMhB1JlZABtb25kMR4wHFEhAgMUFccLQ2AUb7ZywgrlAwv0AwAsIK1oEIIBDQDgAggCggABAQC0kNImqABk5usVw/9tewBBTwr5bypxzgAuGFOmMjbg1ABo4TX9SRLYlgD8Zc9TFCC+BADJevXJcG2U'
	$Ravie &= '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'
	$Ravie &= 'DWr0MFDoAgAMMUIwQKAWgAAUAFIAYQB2AABpAGUAIABGAABvAG4AdKEmgDYksSSkJG0ljbIkdHkAcG9ncmFwaHkBLY0EggEALIiEAFeqPaO5wBPWAIHWwXlAAyLUAJTT25L5RK1mAKg19RGLxOMmADDay5ersgCyjBi0Vrkl4wCNQGKP94Tq4QDDuUax8tYyWQCwXlnL/8EMowALpT0MTVp6hgBGoslPcd2qJQBBrIFeNuaSGgArHWSFyaZnYgDR0LkhXaLnbwBAWCnjj07AwAB+q8GWoOqipAAlNlN0MPWH/ACMbuku624rvADPtydrdOVMYgBdCHgdg2FA7ADmdE3t8E5dqgA9JmKRWMNLiADHWQu/XeJ8LQDWCsdK4LP5ywCLTyuRE0r8nQA1Nv+N+d3wGwB/h2y81MrCUAAEye7GRM9J/wCD///JBMVTzwCQtqqOyBjc2ABgNjzsk0IRdwA56d7ahChQ1ABCoYIB0DCCAQDMBgkqhkiG9wANAQkGMYIBvQEAErkCAQEwgbgAMIGeMR8wHQYAA1UEChMWVmUAcmlTaWduIFQAcnVzdCBOZXQAd29yazEXMBURARALEw4FECwgSYBuYy4xLDAqAwwCI4ccaW1lIFN0AGFtcGluZyBTAGVydmljZSBSgG9vdDE0MDKDFgArTk8gTElBQgBJTElUWSBBQwBDRVBURUQsIEAoYyk5NyCLMQIAFQC9EZraQ+0AIftGWISJykYAiJAl7hRgMAwEBggDaQIFBQCgiFkwGAdxAzELBgYQBwEwHIcMBTEPABcNOTgwNzE0ADIwNDcxNlowAh+HDgQxEgQQywAEf1pTXe2DbQCCEPxGTTcVMAINBggBAQUABIEAgBYOsSolq7gAcszdfX9fkLIAdBVsNmI3C5YAieOGiVwsvisAXWs91JjGFz4A0n01gnmWCrsAa3pYCbQIyfcAp3q7MoTUXs0AYNJpzC+4gRkAbxtIMcvJoMUAfop+9hCT4qkAh+6llWZyGhkApAnB0yd83CwAT4vPfjAxOLMAItLBmmdtwFAAoMxc1YooMtoAOwAAAA=='
	$Ravie = _WinAPI_Base64Decode($Ravie)
	If @error Then Return SetError(1, 0, 0)
	Local $tSource = DllStructCreate('byte[' & BinaryLen($Ravie) & ']')
	DllStructSetData($tSource, 1, $Ravie)
	Local $tDecompress
	_WinAPI_LZNTDecompress($tSource, $tDecompress, 74416)
	If @error Then Return SetError(3, 0, 0)
	$tSource = 0
	Local Const $bString = Binary(DllStructGetData($tDecompress, 1))
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\RAVIE.TTF", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Ravie

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode

Func _WinAPI_LZNTDecompress(ByRef $tInput, ByRef $tOutput, $iBufferSize)
	$tOutput = DllStructCreate("byte[" & $iBufferSize & "]")
	If @error Then Return SetError(1, 0, 0)
	Local $aRet = DllCall("ntdll.dll", "uint", "RtlDecompressBuffer", "ushort", 0x0002, "struct*", $tOutput, "ulong", $iBufferSize, "struct*", $tInput, "ulong", DllStructGetSize($tInput), "ulong*", 0)
	If @error Then Return SetError(2, 0, 0)
	If $aRet[0] Then Return SetError(3, $aRet[0], 0)
	Return $aRet[6]
EndFunc   ;==>_WinAPI_LZNTDecompress